#include <cstdlib>
#include <iostream>
#include <string>

#include <boost/bind.hpp>

#include <boost/context/all.hpp>


template<typename Value>
class my_iterator {
public:
	my_iterator(): 
		stack_(16384),
		base_context_(),
		run_context_( &my_iterator::run , base_context_, this, boost::move(stack_) ),
		done(false)
	{
	}
	~my_iterator()
	{
		if(!done) {
			done = true;
			base_context_.jump_to(run_context_);
		}
	}
	Value &operator++()
	{
		base_context_.jump_to(run_context_);
		return value;
	}
protected:
	virtual Value run() = 0;
	
	void yeild(Value const &v)
	{
		if(done) {
			throw iter_exception();
		}
		value = v;
		run_context_.jump_to(base_context_);
	}
private:
	struct iter_exception{};
        boost::protected_stack stack_;
	boost::context<> base_context_;
	boost::context<> run_context_;

	Value value;
	bool done;

	static void run(void *vself)
	{
		my_iterator *self = static_cast<my_iterator*>(vself);
		try {
			Value final = self->run();
			self->value = final;
		}
		catch(iter_exception const &e) {
			self->run_context_.jump_to(self->base_context_);
		}
		self->done = true;
	}
};

struct string_iter : public my_iterator<std::string>
{
	std::string run()
	{
		struct test {
			test() {
				std::cout << "Ctor\n";
			}
			~test() {
				std::cout << "Dtor\n";
			}
		} test_instance;
		while(std::cin && !std::cin.eof()) {
			std::string tmp;
			std::cin >> tmp;
			if(std::cin && !tmp.empty()) {
				yeild(tmp);
			}
			else {
				return "";
			}
		}
		return "";
	}
};


int main()
{
	std::string tmp;
	{
		string_iter it;
		int n=0;
		while((tmp = ++it)!="") {
			std::cout << tmp << std::endl;
			if(n++==10)
				break;
		}
	}
	std::cout << "Done" << std::endl;
}
