#include <cstdlib>
#include <iostream>
#include <string>

#include <boost/asio.hpp>

#include <boost/bind.hpp>
#include <boost/thread.hpp>
#include <boost/context/all.hpp>


class my_io {
public:
	my_io(boost::asio::io_service &srv,boost::context<> &base): 
		socket_(srv),
		stack_(16384),
		base_context_(base),
		run_context_( &my_io::run , base_context_, this, boost::move(stack_) )
	{
	}
	virtual ~my_io() {}
	boost::asio::local::stream_protocol::socket socket_;
	void exec()
	{
		base_context_.jump_to(run_context_);
	}
protected:
	virtual void run() = 0;
	
	size_t write(char const *buf,size_t n)
	{
		boost::system::error_code e;
		size_t r = write(buf,n,e);
		if(e) {
			throw boost::system::system_error(e);
		}
		return r;
	}
	
	size_t read(char *buf,size_t n)
	{
		boost::system::error_code e;
		size_t r = read(buf,n,e);
		if(e) {
			throw boost::system::system_error(e);
		}
		return r;
	}

	size_t read(char *buf,size_t n,boost::system::error_code &e)
	{
		error_ = &e;

		boost::asio::async_read(
			socket_,
			boost::asio::buffer(buf,n),
			boost::bind(&my_io::on_completed,this,
				boost::asio::placeholders::bytes_transferred,
				boost::asio::placeholders::error));

		run_context_.jump_to(base_context_);
		return size_; 
	}
	
	size_t write(char const *buf,size_t n,boost::system::error_code &e)
	{
		error_ = &e;

		boost::asio::async_write(
			socket_,
			boost::asio::buffer(buf,n),
			boost::bind(&my_io::on_completed,this,
				boost::asio::placeholders::bytes_transferred,
				boost::asio::placeholders::error));

		run_context_.jump_to(base_context_);
		return size_; 

	}
private:
	void on_completed(size_t n,boost::system::error_code const &e)
	{
		*error_ = e;
		size_ = n;
		base_context_.jump_to(run_context_);
	}
	
        boost::protected_stack stack_;
	boost::context<> &base_context_;
	boost::context<> run_context_;
	boost::system::error_code *error_;
	size_t size_;

	static void run(void *vself)
	{
		my_io *self = static_cast<my_io*>(vself);
		try {
			self->run();
		}
		catch(std::exception const &e) {
			std::cerr << "Logging: " << e.what() << std::endl;
		}
	}
};

#ifdef USE_THREADS
struct writer  {
	writer():
		socket_(srv_)
	{
	}
	~writer()
	{
		std::cout << "Writer done" << std::endl;
	}
	void run()
	{
		for(int i=0;i<1000000;i++) {
			char buf[8];
			snprintf(buf,sizeof(buf),"%d",i);
			boost::asio::write(socket_,boost::asio::buffer(buf,8));
			boost::asio::read(socket_,boost::asio::buffer(buf,8));
		}
		socket_.close();
	}
	boost::asio::io_service srv_;
	boost::asio::local::stream_protocol::socket socket_;
};

struct reader {
	reader():
		socket_(srv_)
	{
	}
	~reader()
	{
		std::cout << "Reader done" << std::endl;
	}
	void run()
	{
		try {
			for(;;) {
				char buf[8];
				boost::asio::read(socket_,boost::asio::buffer(buf,8));
				std::cout << buf << std::endl;
				boost::asio::write(socket_,boost::asio::buffer(buf,8));
			}
		}
		catch(std::exception const &e) {
			std::cerr << e.what() << std::endl;
		}
	}
	boost::asio::io_service srv_;
	boost::asio::local::stream_protocol::socket socket_;
};
#elif defined USE_ASIO
struct writer  {
	int i;
	char buf[8];
	writer(boost::asio::io_service &srv):
		socket_(srv)
	{
		i=0;
	}
	~writer()
	{
		std::cout << "Writer done" << std::endl;
	}
	void run()
	{
		if(i<1000000) {
			snprintf(buf,sizeof(buf),"%d",i);
			boost::asio::async_write(socket_,boost::asio::buffer(buf,8),
					boost::bind(&writer::on_written,this,
						boost::asio::placeholders::bytes_transferred,
						boost::asio::placeholders::error));
			i++;
		}
		else {
			socket_.close();
		}
	}
	void on_written(size_t n,boost::system::error_code const &e)
	{
		if(e) return;
		boost::asio::async_read(socket_,boost::asio::buffer(buf,8),
				boost::bind(&writer::on_read,this,
					boost::asio::placeholders::bytes_transferred,
					boost::asio::placeholders::error));
	}
	void on_read(size_t n,boost::system::error_code const &e)
	{
		if(e) return;
		run();
	}

	boost::asio::local::stream_protocol::socket socket_;
};

struct reader {
	char buf[8];
	reader(boost::asio::io_service &srv):
		socket_(srv)
	{
	}
	~reader()
	{
		std::cout << "Reader done" << std::endl;
	}
	void run()
	{
		boost::asio::async_read(socket_,boost::asio::buffer(buf,8),
					boost::bind(&reader::on_read,this,
						boost::asio::placeholders::bytes_transferred,
						boost::asio::placeholders::error));
	}
	void on_read(size_t n,boost::system::error_code const &e)
	{
		if(e) {
			std::cerr << e.message() << std::endl;
			return;
		}
		std::cout << buf << std::endl;
		boost::asio::async_write(socket_,boost::asio::buffer(buf,8),
					boost::bind(&reader::on_write,this,
						boost::asio::placeholders::bytes_transferred,
						boost::asio::placeholders::error));
	}
	void on_write(size_t n,boost::system::error_code const &e)
	{
		if(e) {
			std::cerr << e.message() << std::endl;
			return;
		}
		run();
	}
	boost::asio::local::stream_protocol::socket socket_;
};



#else

struct writer : public my_io {
	writer(boost::asio::io_service &srv,boost::context<> &base):
		my_io(srv,base)
	{
	}
	~writer()
	{
		std::cout << "Writer done" << std::endl;
	}
	void run()
	{
		for(int i=0;i<1000000;i++) {
			char buf[8];
			snprintf(buf,sizeof(buf),"%d",i);
			write(buf,8);
			read(buf,8);
		}
		socket_.close();
	}
};


struct reader : public my_io {
	reader(boost::asio::io_service &srv,boost::context<> &base):
		my_io(srv,base)
	{
	}
	~reader()
	{
		std::cout << "Reader done" << std::endl;
	}
	void run()
	{
		for(;;) {
			char buf[8];
			read(buf,8);
			std::cout << buf << std::endl;
			write(buf,8);
		}
	}
};

#endif

int main()
{
	#ifdef USE_THREADS
	reader rd;
	writer wr;
	#elif defined USE_ASIO
	boost::asio::io_service srv;
	reader rd(srv);
	writer wr(srv);
	#else
	boost::context<> base;
	boost::asio::io_service srv;
	reader rd(srv,base);
	writer wr(srv,base);
	#endif
	boost::asio::local::connect_pair(rd.socket_,wr.socket_);
	#ifdef USE_THREADS
	boost::thread t1(boost::bind(&reader::run,&rd));
	boost::thread t2(boost::bind(&writer::run,&wr));
	t1.join();
	t2.join();
	#elif defined USE_ASIO
	rd.run();
	wr.run();
	srv.run();
	#else
	rd.exec();
	wr.exec();
	srv.run();
	#endif
	
	std::cout << "Done" << std::endl;
}
