//#define BOOST_MPL_LIMIT_VECTOR_SIZE 20

#ifndef SUB_STATE_MACHINE_TWO__H__
#define SUB_STATE_MACHINE_TWO__H__

#include "events.h"
#include <boost/msm/back/favor_compile_time.hpp>
#include <boost/msm/back/state_machine.hpp>
#include <boost/msm/front/state_machine_def.hpp>
#include <boost/msm/front/euml/euml.hpp>

#include <iostream>

namespace msm = boost::msm;
namespace mpl = boost::mpl;

struct RunningStateMachine_two_ : public msm::front::state_machine_def<RunningStateMachine_two_>
{
  // no need for exception handling 
  typedef int no_exception_thrown;

  // optional entry/exit methods
  template <class Event,class FSM>
  void on_entry(Event const&,FSM& ms_) {std::cout << "entering: " << ms_.m_SmName << std::endl;}
  template <class Event,class FSM>
  void on_exit(Event const&,FSM& ms_) {std::cout << "leaving: " << ms_.m_SmName << std::endl;}

  // The list of FSM states
  struct InitialState : public msm::front::state<> 
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: RunningStateMachine_two::InitialState" << std::endl;}
    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: RunningStateMachine_two::InitialState" << std::endl;}
  };

  struct InitialAllOkState : public msm::front::state<> 
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: RunningStateMachine_two::InitialAllOkState" << std::endl;}
    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: RunningStateMachine_two::InitialAllOkState" << std::endl;}
  };

  struct ExitOnErrorState : public msm::front::exit_pseudo_state<eventError> 
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: RunningStateMachine_two::ExitOnErrorState" << std::endl;}
    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: RunningStateMachine_two::ExitOnErrorState" << std::endl;}
  };

  struct  ExitOnSuccessState: public msm::front::exit_pseudo_state<eventOk>
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: ExitOnSuccessState" << std::endl;}

    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: ExitOnSuccessState" << std::endl;}
  };

  // The list of FSM states
  struct State2 : public msm::front::state<>
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: State2" << std::endl;}

    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: State2" << std::endl;}
  };

  struct State3 : public msm::front::state<>
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: State3" << std::endl;}

    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: State3" << std::endl;}
  };

  struct State4 : public msm::front::state<>
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: State4" << std::endl;}

    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: State4" << std::endl;}
  };

  struct State5 : public msm::front::state<>
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: State5" << std::endl;}

    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: State5" << std::endl;}
  };

  struct State6 : public msm::front::state<>
  {
    // optional entry/exit methods
    template <class Event,class FSM>
    void on_entry(Event const&,FSM& ) {std::cout << "entering: State6" << std::endl;}

    template <class Event,class FSM>
    void on_exit(Event const&,FSM& ) {std::cout << "leaving: State6" << std::endl;}
  };

  // the initial state of the player SM. Must be defined
  typedef boost::mpl::vector<InitialState, InitialAllOkState> initial_state;

  void onEvent11_2(event11_2 const&)       { std::cout << "Action: RunningStateMachine_two::onEvent11_2" << std::endl; }

  struct transition_table : mpl::vector<
    //     Start         Event        Next      Action                                      Guard
    //    +-------------+------------+---------+-------------------------------------------+----------------------+
    a_row < InitialState      , event11_2   , State2 , &RunningStateMachine_two_::onEvent11_2 >,
    _row < State2            , event11_3   , State3                                            >,
    _row < State3            , event11_4   , State4                                            >,
    _row < State4            , event11_5   , State5                                            >,
    _row < State5            , event11_6   , State6                                            >,
    _row < State6            , event11_7   , ExitOnSuccessState                                >,
    _row < InitialAllOkState , eventError  , ExitOnErrorState                                  >
    //    +-------------+------------+---------+-------------------------------------------+----------------------+
  > {};

  static const char m_SmName[];

};

typedef msm::back::state_machine<RunningStateMachine_two_,
  ::boost::msm::back::NoHistory, 
  ::boost::msm::back::favor_compile_time> RunningStateMachine_two;

#endif // SUB_STATE_MACHINE_TWO__H__