//#define BOOST_MPL_LIMIT_VECTOR_SIZE = 20

#ifndef COMPOSITE_ENTRY_EVENTS_INCLUDE__H__
#define COMPOSITE_ENTRY_EVENTS_INCLUDE__H__

// Composite_Sate_explicit_entry.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "events.h"

#include <boost/msm/back/favor_compile_time.hpp>
#include "boost/msm/back/state_machine.hpp"
#include "boost/msm/front/state_machine_def.hpp"
#include "sub_state_machine_one.h"
#include "sub_state_machine_two.h"
#include "sub_state_machine_three.h"
#include "sub_state_machine_four.h"
#include "sub_state_machine_five.h"
#include "sub_state_machine_six.h"
#include "sub_state_machine_seven.h"


namespace msm = boost::msm;
namespace mpl = boost::mpl;

#include <iostream>

namespace test_fsm // Concrete FSM implementation
{
  struct SM1_;

  typedef msm::back::state_machine<SM1_,
    ::boost::msm::back::NoHistory, 
    ::boost::msm::back::favor_compile_time > SM1;

  // Concrete FSM implementation 
  struct SM1_ : public msm::front::state_machine_def<SM1_>
  {
    // no need for exception handling 
    typedef int no_exception_thrown;

    // The list of FSM states
    struct Idle : public msm::front::state<> 
    {
      // optional entry/exit methods
      template <class Event,class FSM>
      void on_entry(Event const&,FSM& ms_) {std::cout << "entering: Idle " << ms_.m_SmName << std::endl;}
      template <class Event,class FSM>
      void on_exit(Event const&,FSM& ) {std::cout << "leaving: Idle" << std::endl;}
    };


    struct RunningStateMachine_ : public msm::front::state_machine_def<RunningStateMachine_>
    {
      // no need for exception handling 
      typedef int no_exception_thrown;

      // optional entry/exit methods
      template <class Event,class FSM>
      void on_entry(Event const&,FSM& ms_) {std::cout << "entering: RunningStateMachine " << ms_.m_SmName << std::endl;}
      template <class Event,class FSM>
      void on_exit(Event const&,FSM& ) {std::cout << "leaving: RunningStateMachine" << std::endl;}

      // The list of FSM states
      struct InitialState : public msm::front::entry_pseudo_state<> 
      {
        // optional entry/exit methods
        template <class Event,class FSM>
        void on_entry(Event const&,FSM& ) {std::cout << "entering: InitialState" << std::endl;}
        template <class Event,class FSM>
        void on_exit(Event const&,FSM& ) {std::cout << "leaving: InitialState" << std::endl;}
      };

      // The list of FSM states
      struct State2 : public msm::front::state<> 
      {
        // optional entry/exit methods
        template <class Event,class FSM>
        void on_entry(Event const&,FSM& ) {std::cout << "entering: State2" << std::endl;}

        template <class Event,class FSM>
        void on_exit(Event const&,FSM& ) {std::cout << "leaving: State2" << std::endl;}
      };

      // The list of FSM states
      struct State3 : public msm::front::exit_pseudo_state<eventFinished> 
      {
        // optional entry/exit methods
        template <class Event,class FSM>
        void on_entry(Event const&,FSM& ) {std::cout << "entering: State3" << std::endl;}


        template <class Event,class FSM>
        void on_exit(Event const&,FSM& ) {std::cout << "leaving: State3" << std::endl;}
      };

      // the initial state of the player SM. Must be defined
      typedef InitialState initial_state;

      void onEvent1(event1 const&) { std::cout << "Action: RunningStateMachine::onEvent1" << std::endl; }
      void onEvent2(event2 const&) { std::cout << "Action: RunningStateMachine::onEvent2" << std::endl; }
      void onEvent3(event3 const&) { std::cout << "Action: RunningStateMachine::onEvent3" << std::endl; }
      void onEvent4(event4 const&) { std::cout << "Action: RunningStateMachine::onEvent4" << std::endl; }
      void onEvent5(event5 const&) { std::cout << "Action: RunningStateMachine::onEvent5" << std::endl; }
      void onEvent6(event6 const&) { std::cout << "Action: RunningStateMachine::onEvent6" << std::endl; }
      void onEvent7(event7 const&) { std::cout << "Action: RunningStateMachine::onEvent7" << std::endl; }
      
      void onError(eventError const&) { std::cout << "Action: RunningStateMachine::onError" << std::endl; }

      struct transition_table : mpl::vector<
        //     Start          Event         Next           Action                              Guard
        //    +--------------+-------------+--------------+-----------------------------------+----------------------+
         a_row < InitialState                      , event1    , RunningStateMachine_one   , &RunningStateMachine_::onEvent1 >,
         a_row < InitialState                      , event2    , RunningStateMachine_two   , &RunningStateMachine_::onEvent2 >,
         a_row < InitialState                      , event3    , RunningStateMachine_three , &RunningStateMachine_::onEvent3 >,
         a_row < InitialState                      , event4    , RunningStateMachine_four  , &RunningStateMachine_::onEvent4 >,
         a_row < InitialState                      , event5    , RunningStateMachine_five  , &RunningStateMachine_::onEvent5 >,
         a_row < InitialState                      , event6    , RunningStateMachine_six   , &RunningStateMachine_::onEvent6 >,
         //a_row < InitialState                      , event7    , RunningStateMachine_seven , &RunningStateMachine_::onEvent7 >,

          _row < RunningStateMachine_one::exit_pt
               < RunningStateMachine_one::ExitOnSuccessState   > , eventOk , State3 >,
          _row < RunningStateMachine_two::exit_pt
               < RunningStateMachine_two::ExitOnSuccessState   > , eventOk , State3 >,
          _row < RunningStateMachine_three::exit_pt
               < RunningStateMachine_three::ExitOnSuccessState > , eventOk , State3 >,
          _row < RunningStateMachine_four::exit_pt
               < RunningStateMachine_four::ExitOnSuccessState > , eventOk , State3 >,
          _row < RunningStateMachine_five::exit_pt
               < RunningStateMachine_five::ExitOnSuccessState > , eventOk , State3 >,
          _row < RunningStateMachine_six::exit_pt
               < RunningStateMachine_six::ExitOnSuccessState > , eventOk , State3 >,
          //_row < RunningStateMachine_seven::exit_pt
          //     < RunningStateMachine_seven::ExitOnSuccessState > , eventOk , State3 >,


         a_row < RunningStateMachine_one::exit_pt
               < RunningStateMachine_one::ExitOnErrorState   > , eventError , State3, &RunningStateMachine_::onError >,
         a_row < RunningStateMachine_two::exit_pt
               < RunningStateMachine_two::ExitOnErrorState   > , eventError , State3, &RunningStateMachine_::onError >,
         a_row < RunningStateMachine_three::exit_pt
               < RunningStateMachine_three::ExitOnErrorState > , eventError , State3, &RunningStateMachine_::onError >,
         a_row < RunningStateMachine_four::exit_pt
               < RunningStateMachine_four::ExitOnErrorState  > , eventError , State3, &RunningStateMachine_::onError >,
         a_row < RunningStateMachine_five::exit_pt
               < RunningStateMachine_five::ExitOnErrorState  > , eventError , State3, &RunningStateMachine_::onError >,
         a_row < RunningStateMachine_six::exit_pt
               < RunningStateMachine_six::ExitOnErrorState  > , eventError , State3, &RunningStateMachine_::onError >
         //a_row < RunningStateMachine_seven::exit_pt
         //      < RunningStateMachine_seven::ExitOnErrorState  > , eventError , State3, &RunningStateMachine_::onError >


        //    +--------------+-------------+--------------+-----------------------------------+----------------------+
      > {};
      static const char m_SmName[];
    };

    typedef msm::back::state_machine<RunningStateMachine_,
      ::boost::msm::back::NoHistory, 
      ::boost::msm::back::favor_compile_time> RunningStateMachine;

    // the initial state of the player SM. Must be defined
    typedef Idle initial_state;

    // transition actions
    void onEvent1(event1 const&) { std::cout << "Action: MS1::onEvent1" << std::endl; }
    void onEvent2(event2 const&) { std::cout << "Action: MS1::onEvent2" << std::endl; }
    void onEvent3(event3 const&) { std::cout << "Action: MS1::onEvent3" << std::endl; }
    void onEvent4(event4 const&) { std::cout << "Action: MS1::onEvent4" << std::endl; }
    void onEvent5(event5 const&) { std::cout << "Action: MS1::onEvent5" << std::endl; }
    void onEvent6(event6 const&) { std::cout << "Action: MS1::onEvent6" << std::endl; }
    void onEvent7(event7 const&) { std::cout << "Action: MS1::onEvent7" << std::endl; }

    // Transition table for SubFsm2
    struct transition_table : mpl::vector<
      //      Start  Event    Next                  Action              Guard
      //     +------+--------+---------------------+-------------------+----------------------+
      a_row < Idle                          , event1    ,  RunningStateMachine::entry_pt 
                                                         < RunningStateMachine::InitialState > , &SM1_::onEvent1 >,
      a_row < Idle                          , event2    ,  RunningStateMachine::entry_pt 
                                                         < RunningStateMachine::InitialState > , &SM1_::onEvent2 >,
      a_row < Idle                          , event3    ,  RunningStateMachine::entry_pt 
                                                         < RunningStateMachine::InitialState > , &SM1_::onEvent3 >,
      a_row < Idle                          , event4    ,  RunningStateMachine::entry_pt 
                                                         < RunningStateMachine::InitialState > , &SM1_::onEvent4 >,
      a_row < Idle                          , event5    ,  RunningStateMachine::entry_pt 
                                                         < RunningStateMachine::InitialState > , &SM1_::onEvent5 >,
      a_row < Idle                          , event6    ,  RunningStateMachine::entry_pt 
                                                         < RunningStateMachine::InitialState > , &SM1_::onEvent6 >,
      a_row < Idle                          , event7    ,  RunningStateMachine::entry_pt 
                                                         < RunningStateMachine::InitialState > , &SM1_::onEvent7 >,

      _row  < RunningStateMachine::exit_pt
            < RunningStateMachine::State3 > , eventFinished , Idle                                               >
      //     +------+--------+---------------------+-------------------+----------------------+
    > {};

    static const char m_SmName[];

    template <class FSM,class Event>
    void no_transition(Event const& ,FSM&, int state)
    {
      std::cout << "no_transition" << std::endl; 
    }

  };

}

int _tmain(int argc, _TCHAR* argv[])
{
  test_fsm::SM1 sm;
  sm.start();
  sm.process_event(event1());
  sm.process_event(event11_1());
  sm.process_event(event11_2());
  sm.process_event(event11_3());
  sm.process_event(event11_4());
  sm.process_event(event11_5());
  sm.process_event(event11_6());
  sm.process_event(eventError());
  sm.process_event(event11_7());

  sm.process_event(event2());
  sm.process_event(event11_1());
  sm.process_event(event11_2());
  sm.process_event(event11_3());
  sm.process_event(event11_4());
  sm.process_event(event11_5());
  sm.process_event(event11_6());
  sm.process_event(eventError());
  sm.process_event(event11_7());

  sm.process_event(event3());
  sm.process_event(event11_1());
  sm.process_event(event11_2());
  sm.process_event(event11_3());
  sm.process_event(event11_4());
  sm.process_event(event11_5());
  sm.process_event(event11_6());
  sm.process_event(eventError());
  sm.process_event(event11_7());

  sm.process_event(event4());
  sm.process_event(event11_1());
  sm.process_event(event11_2());
  sm.process_event(event11_3());
  sm.process_event(event11_4());
  sm.process_event(event11_5());
  sm.process_event(event11_6());
sm.process_event(eventError());
  sm.process_event(event11_7());

  sm.process_event(event5());
  sm.process_event(event11_1());
  sm.process_event(event11_2());
  sm.process_event(event11_3());
  sm.process_event(event11_4());
  sm.process_event(event11_5());
  sm.process_event(event11_6());
  sm.process_event(eventError());
  sm.process_event(event11_7());

  sm.process_event(event6());
  sm.process_event(event11_1());
  sm.process_event(event11_2());
  sm.process_event(event11_3());
  sm.process_event(event11_4());
  sm.process_event(event11_5());
  sm.process_event(event11_6());
  sm.process_event(eventError());
  sm.process_event(event11_7());

  sm.process_event(event7());
  sm.process_event(event11_1());
  sm.process_event(event11_2());
  sm.process_event(event11_3());
  sm.process_event(event11_4());
  sm.process_event(event11_5());
  sm.process_event(event11_6());
  sm.process_event(eventError());
  sm.process_event(event11_7());
  
  return 0;
}

#endif // COMPOSITE_ENTRY_EVENTS_INCLUDE__H__