#ifndef BOOST_PRECISE_TIMER_WIN32_HPP
#define BOOST_PRECISE_TIMER_WIN32_HPP

// (C) Copyright Vaucher Philippe 2006

// -------------------------- Includes --------------------------

// Standard headers
#include <stdexcept>

// Windows headers
#include <windows.h>


// -------------------------- Code --------------------------

namespace boost
{

	class precise_timer
	{
	
	public:

		precise_timer()
		{
			if(!QueryPerformanceFrequency(&m_frequency))
				throw std::runtime_error("precise_timer: QueryPerformanceFrequency() indicated there's no high-resolution performance counter");
			m_frequency.QuadPart /= 1000;
			start();
		}

		void start(double offset = 0.0)
		{
			m_value = offset;

			if(!QueryPerformanceCounter(&m_begin))
				throw std::runtime_error("precise_timer: QueryPerformanceCounter() failed");
		}

		void stop()
		{
			m_value = elapsed();
		}

		void resume()
		{
			start(m_value);
		}

		double value() const
		{
			return m_value;
		}

		double elapsed()
		{
			if(!QueryPerformanceCounter(&m_end))
				throw std::runtime_error("precise_timer: QueryPerformanceCounter() failed");

			return m_value + ((m_end.QuadPart - m_begin.QuadPart) / m_frequency.QuadPart / 1000.0);
		}


	private:

		LARGE_INTEGER m_begin, m_end, m_frequency;
		double m_value;

	};

}

#endif
