#ifndef BOOST_PRECISE_TIMER_LINUX_HPP
#define BOOST_PRECISE_TIMER_LINUX_HPP

// (C) Copyright Vaucher Philippe 2006

// -------------------------- Includes --------------------------

// Standard headers
#include <memory>
#include <stdexcept>

// Linux headers
#include <sys/time.h>


// -------------------------- Code --------------------------

namespace boost
{

	class precise_timer
	{

	public:

		precise_timer() : m_value(0.0)
		{
			start();
		}

		void start(double offset = 0.0)
		{
			m_value = offset;
			if(gettimeofday(&m_begin, 0) < 0)
				throw std::runtime_error("precise_timer: gettimeofday() failed");
		}

		void stop()
		{
			m_value = elapsed();
		}

		void resume()
		{
			start(m_value);
		}

		double value() const
		{
			return m_value;
		}

		double elapsed()
		{
			if(gettimeofday(&m_end, 0) < 0)
				throw std::runtime_error("precise_timer: gettimeofday() failed");

			return m_value + (m_end.tv_sec - m_begin.tv_sec) + ((m_end.tv_usec - m_begin.tv_usec) / 1000000.0);
		}

	private:

		timeval m_begin;
		timeval m_end;
		double  m_value;

	};

}

#endif
