#include <iostream>

#include <boost/precise_timer.hpp>

using namespace std;

void mysleep(int milliseconds)
{
	cout << "Sleeping for " << (milliseconds/1000.0) << " seconds" << endl;
	#ifdef WIN32
		Sleep(milliseconds);
	#else
		usleep(milliseconds*1000);
	#endif
}

int main()
{
	cout << "Starting timer" << endl;
	boost::precise_timer tmr;
	mysleep(200);
	cout << "Current value: " << tmr.elapsed() << endl;
	mysleep(200);
	cout << "Current value: " << tmr.elapsed() << endl;
	
	cout << "Stopping timer" << endl;
	tmr.stop();
	cout << "Timer value: " << tmr.value() << endl;

	mysleep(1000);
	cout << "This last sleep should not be timed as the timer is stopped" << endl;
	cout << "Timer value: " << tmr.value() << endl;

	cout << "Resuming timer" << endl;
	tmr.resume();
	mysleep(200);
	cout << "Current value: " << tmr.elapsed() << endl;
	mysleep(200);
	cout << "Current value: " << tmr.elapsed() << endl;

	cout << "Restarting timer" << endl;
	tmr.start();
	mysleep(200);
	cout << "Current value: " << tmr.elapsed() << endl;
	mysleep(200);
	cout << "Current value: " << tmr.elapsed() << endl;

	return 0;
}
